#include <afx.h>
#include <stdio.h>
#include "errmsg.h"

extern char szName[];


//@func Print an error message

void PrintError(
	const char *szFilename,         //@parm Name of file in which error occurred
	long lLine,                             //@parm Line number (can be NO_LINE)
	int nError)                                     //@parm Error message
{
	char achErrMsg[1024];
    
    if(szFilename)
	fprintf(stdout, "%s", szFilename);

	if(lLine != NO_LINE)
		fprintf(stdout, "(%ld)", lLine);
		
	if(szFilename)
	    fputs(": ", stdout);

	switch(nError)
	{
	case CFileException::none:
	case CFileException::generic:
	case CFileException::fileNotFound:
	case CFileException::badPath:
	case CFileException::tooManyOpenFiles:
	case CFileException::accessDenied:
	case CFileException::invalidFile:
	case CFileException::removeCurrentDir:
	case CFileException::directoryFull:
	case CFileException::badSeek:
	case CFileException::hardIO:
	case CFileException::sharingViolation:
	case CFileException::lockViolation:
	case CFileException::diskFull:
	case CFileException::endOfFile:
		nError += 100;
		break;
		
	default:
		break;
	}
	
	achErrMsg[0] = '\0';

	if(LoadString(NULL, nError, achErrMsg, 1023))
		fputs(achErrMsg, stdout);
	else
		fprintf(stdout, "Error %d", nError);

	fputc('\n', stdout);
}


